<?php

namespace App\Classes;

use App\Models\Lang;
use App\Models\Translation;
use Nwidart\Modules\Facades\Module;

class LangTrans
{
    public static $mainTranslations = [
        'common' => [
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
            'id' => 'Id',
            'action' => 'Action',
            'placeholder_default_text' => 'Please Enter {0}',
            'placeholder_social_text' => 'Please Enter {0} Url',
            'placeholder_search_text' => 'Search By {0}',
            'select_default_text' => 'Select {0}...',
            'create' => 'Create',
            'edit' => 'Edit',
            'update' => 'Update',
            'cancel' => 'Cancel',
            'delete' => 'Delete',
            'success' => 'Success',
            'error' => 'Error',
            'yes' => 'Yes',
            'no' => 'No',
            'fix_errors' => 'Please Fix Below Errors.',
            'cancelled' => 'Cancelled',
            'pending' => 'Pending',
            'paid' => 'Paid',
            'completed' => 'Completed',
            'save' => 'Save',
            'all' => 'All',
            'name' => 'Name',
            'back' => 'Back',
            'max_amount' => 'Max. Amount',
            'date_time' => 'Date Time',
            'select_time' => 'Select Time',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'search' => 'Search',
            'date' => 'Date',
            'confirm' => 'Confirm',
            'title' => 'Title',
            'value' => 'Value',
            'add' => 'Add',
            'view' => 'View',
            'edit' => 'Edit',
            'download' => 'Download',
            'total' => 'Total',
            'email' => 'Email',
            'phone' => 'Phone',
            'purchase_code' => 'Purchase Code',
            'verify_purchase' => 'Verify Purchase',
            'install' => 'Install',
            'installing' => 'Installing',
            'updating' => 'Updating',
            'free' => 'Free',
            'paid' => 'Paid',
            'domain' => 'Domain',
            'verify' => 'Verify',
            'send' => 'Send',
            'upload' => 'Upload',
            'view_all' => 'View All',
            'unpaid' => 'Unpaid',
            'loading' => 'Loading',
            'update_app' => 'Update App',
            'welcome_back' => 'Welcome {0}',
            'off' => 'Off',
            'on_create' => 'On Create',
            'on_update' => 'On Update',
            'on_delete' => 'On Delete',
            'demo_account_credentials' => 'Demo account login credentials',
            'created_by' => 'Created By',
            'import' => 'Import',
            'file' => 'File',
            'copy_url' => 'Copy Url',
            'print' => 'Print',
            'amount' => 'Amount',
            'status' => 'Status',
            'active' => 'Active',
            'inactive' => 'Inactive',
            'yes' => 'Yes',
            'no' => 'No',
            'verified' => 'Verified',
            'configure' => 'Configure',
            'logo' => 'Logo',
            'slug' => 'Slug',
            'description' => 'Description',
            'image' => 'Image',
            'address' => 'Address',
            'not_allowed' => 'Not Allowed',
            'details' => 'Details',
            'text' => 'Text',
            'link' => 'Link',
            'start' => 'Start',
            'stop' => 'Stop',
            'are_you_sure' => 'Are you sure',
            'basic_details' => 'Basic Details',
            'notes' => 'Notes',
            'more' => 'More',
            'other' => 'Other',
            'continue' => 'Continue',
            'product' => 'Product',
            'service' => 'Service',
        ],
        'menu' => [
            'dashboard' => 'Dashboard',
            'users' => 'Users',
            'staff_members' => 'Staff Members',
            'settings' => 'Settings',
            'company' => 'Company Settings',
            'profile' => 'Profile',
            'translations' => 'Translations',
            'languages' => 'Languages',
            'roles' => 'Role & Permissions',
            'currencies' => 'Currencies',
            'login' => 'Login',
            'logout' => 'Logout',
            'verify_product' => 'Verify Product',
            'modules' => 'Modules',
            'storage_settings' => 'Storage Settings',
            'email_settings' => 'Email Settings',
            'database_backup' => 'Database Backup',
            'companies' => 'Companies',
            'campaigns' => 'Campaigns',
            'call_manager' => 'Call Manager',
            'email_templates' => 'Email Templates',
            'forms'  => 'Forms',
            'form_field_names' => 'Lead Table Fields',
            'leads' => 'Leads',
            'leads_calls' => 'Leads & Calls',
            'lead_details' => 'Lead Details',
            'call_details' => 'Call Details',
            'call_logs' => 'Call Logs',
            'lead_notes' => 'Lead Notes',
            'bookings' => 'Bookings',
            'lead_management' => 'Lead Management',
            'user_management' => 'User Management',
            'lead_follow_up' => 'Lead Follow Up',
            'salesmans' => 'Salesmans',
            'salesman_bookings' => 'Salesman Bookings',
            'messaging' => 'Messaging',
            'expense_categories' => 'Expense Categories',
            'expenses' => 'Expenses',
            'expense_manager' => 'Expense Manager',
            'products' => 'Products',
            'update_app' => 'Update App',
            'setup_company' => 'Setup Company',
        ],
        'dashboard' => [
            'dashboard' => 'Dashboard',
            'active_campaigns' => 'Active Campaigns',
            'call_made' => 'Call Made',
            'total_follow_up' => 'Total Follow Up',
            'total_duration' => 'Total Duration',
            'active_actioned_campaigns' => 'Active Actioned Campaigns',
        ],
        'user' => [
            'add' => 'Add New Staff Member',
            'edit' => 'Edit Staff Member',
            'created' => 'Staff Member Created Successfully',
            'updated' => 'Staff Member Updated Successfully',
            'deleted' => 'Staff Member Deleted Successfully',
            'staff_member_details' => 'Staff Member Details',
            'staff_member' => 'Staff Member',
            'delete_message' => 'Are you sure you want to delete this staff member?',
            'selected_delete_message' => 'Are you sure you want to delete selected  staff member?',
            'import_staff_members' => 'Import Staff Members',
            'email_phone' => 'Email or Phone',
            'user' => 'User',
            'name' => 'Name',
            'created_at' => 'Created At',
            'email' => 'Email',
            'password' => 'Password',
            'login_enabled' => 'Login Enabled',
            'profile_image' => 'Profile Image',
            'company_name' => 'Company Name',
            'phone' => 'Phone Number',
            'address' => 'Address',
            'city' => 'City',
            'state' => 'State',
            'country' => 'Country',
            'zipcode' => 'Zipcode',
            'status' => 'Status',
            'role' => 'Role',
            'profile_updated' => 'Profile Updated Successfully',
            'password_blank' => "Leave blank if you don't want to update password.",
            'admin_account_details' => "Admin Account Details",
            'import_users' => 'Import Users',
        ],
        'salesman' => [
            'add' => 'Add New Salesman',
            'edit' => 'Edit Salesman',
            'created' => 'Salesman Created Successfully',
            'updated' => 'Salesman Updated Successfully',
            'deleted' => 'Salesman Deleted Successfully',
            'salesman_details' => 'Salesman Details',
            'salesman' => 'Salesman',
            'delete_message' => 'Are you sure you want to delete this salesman?',
            'selected_delete_message' => 'Are you sure you want to delete selected salesman?',
            'import_salesman' => 'Import salesmans',
            'name' => 'Name',
            'created_at' => 'Created At',
            'email' => 'Email',
            'password' => 'Password',
            'login_enabled' => 'Login Enabled',
            'profile_image' => 'Profile Image',
            'phone' => 'Phone Number',
            'address' => 'Address',
            'city' => 'City',
            'state' => 'State',
            'country' => 'Country',
            'zipcode' => 'Zipcode',
            'status' => 'Status',
            'profile_updated' => 'Profile Updated Successfully',
            'password_blank' => "Leave blank if you don't want to update password.",
        ],
        'role' => [
            'add' => 'Add New Role',
            'edit' => 'Edit Role',
            'created' => 'Role Created Successfully',
            'updated' => 'Role Updated Successfully',
            'deleted' => 'Role Deleted Successfully',
            'role_details' => 'Role Details',
            'delete_message' => 'Are you sure you want to delete this role?',
            'selected_delete_message' => 'Are you sure you want to delete selected role?',
            'display_name' => 'Display Name',
            'role_name' => 'Role Name',
            'description' => 'Description',
            'user_management' => 'User Management',
            'permissions' => 'Permissions',
        ],
        'notes' => [
            'add' => 'Add New Note',
            'edit' => 'Edit Note',
            'created' => 'Note Created Successfully',
            'updated' => 'Note Updated Successfully',
            'deleted' => 'Note Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this note?',
            'added_on' => 'Added On',
            'added_by' => 'Added By',
        ],
        'campaign' => [
            'add' => 'Add New Campaign',
            'edit' => 'Edit Campaign',
            'created' => 'Campaign Created Successfully',
            'updated' => 'Campaign Updated Successfully',
            'deleted' => 'Campaign Deleted Successfully',
            'campaign_details' => 'Campaign Details',
            'delete_message' => 'Are you sure you want to delete this campaign?',
            'selected_delete_message' => 'Are you sure you want to delete selected campaign?',
            'campaign_view' => 'Campaign View',
            'view_completed_campaigns' => 'View Completed Campaign',
            'progress' => 'Progress',
            'active_campaign' => 'Active Campaign',
            'completed_campaign' => 'Completed Campaign',
            'inactive_campaign' => 'Inactive Campaign',
            'view_all_campaigns' => 'View All Campaigns',
            'name' => 'Name',
            'members' => 'Members',
            'allow_reference_prefix' => 'Allow Reference Prefix',
            'reference_prefix' => 'Reference Prefix',
            'basic_settings' => 'Basic Settings',
            'basic_settings_description' => 'Campaign Settings',
            'about_campaign' => 'About Campaign',
            'about_campaign_description' => 'Campaign Details',
            'import_leads' => 'Import Data',
            'import_leads_description' => 'Campaign Leads/Data',
            'add_detail_field_description' => 'You can create campaign details fields by clicking from below button +Add Detail Field',
            'add_detail_field_error' => 'Add Field Name & Field Value for each record to add new details row or to go to Next Step.',
            'next_step' => 'Next Step',
            'previous_step' => 'Previous Step',
            'field_name' => 'Field Name',
            'field_value' => 'Field Value',
            'field_type' => 'Field Type',
            'add_detail_field' => 'Add Detail Field',
            'form' => 'Form',
            'total_leads' => 'Total Leads',
            'remaining_leads' => 'Remaining Leads',
            'first_actioner' => 'First Actioner',
            'last_actioner' => 'Last Actioner',
            'started_on' => 'Started On',
            'completed_on' => 'Completed On',
            'completed_by' => 'Completed By',
            'no_call_manager_data' => 'No campaign available for call manager... Create one to view call manager',
            'start' => 'Start',
            'stop' => 'Stop',
            'start_and_new_lead' => 'Start & New Lead',
            'new_lead' => 'New Lead',
            'stop_campaign' => 'Stop Campaign',
            'campaign_stopped_successfully' => 'Campaign Stop Successfully',
            'are_you_want_to_stop_campaign' => 'Are you sure you want to stop campaign? After stoping campaign all remaining unactioned leads will be deleted.',
            'are_you_want_to_create_new_lead' => 'Are you sure you want to create new lead for this campaign',
            'new_lead_added' => 'New Lead Added Successfully',
            'save_exit' => 'Save & Exit',
            'next_lead' => 'Next Lead',
            'previous_lead' => 'Previous Lead',
            'skip_lead' => 'Skip Lead',
            'resume' => 'Resume',
            'call_made' => 'Call Made',
            'total_duration' => 'Total Duration',
            'email_template' => 'Email Templage',
            'all_columns' => 'All Columns',
            'matched_columns' => 'Matched Columns',
            'unmatched_columns' => 'Unmatched Columns',
            'column_will_not_imported' => 'This column will not be imported',
            'csv_header_field' => 'Header Field',
            'csv_field_data' => 'Field Data',
            'column_status' => 'Column Status',
        ],
        'email_template' => [
            'add' => 'Add New Email Template',
            'edit' => 'Edit Email Template',
            'created' => 'Email Template Created Successfully',
            'updated' => 'Email Template Updated Successfully',
            'deleted' => 'Email Template Deleted Successfully',
            'email_template_details' => 'Email Template Details',
            'delete_message' => 'Are you sure you want to delete this email template?',
            'selected_delete_message' => 'Are you sure you want to delete selected email template?',
            'name' => 'Name',
            'subject' => 'Subject',
            'body' => 'Body',
            'message' => 'Message',
            'status' => 'Status',
            'sharable' => 'Sharable',
            'sharable_message' => 'Is this template sharable with other team members',
            'status_update' => 'Status Updated Successfully',
            'mail_send_successfully' => 'Email Sent Successfully',
            'mail_send_error_message' => 'Contact admin to setup mail settings',
        ],
        'expense_category' => [
            'add' => 'Add New Expense Category',
            'edit' => 'Edit Expense Category',
            'created' => 'Expense Category Created Successfully',
            'updated' => 'Expense Category Updated Successfully',
            'deleted' => 'Expense Category Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense category?',
            'selected_delete_message' => 'Are you sure you want to delete selected expense category?',
            'expense_category_details' => 'Expense Category Details',
            'name' => 'Expense Category Name',
            'description' => 'Description',
        ],
        'expense' => [
            'add' => 'Add New Expense',
            'edit' => 'Edit Expense',
            'created' => 'Expense Created Successfully',
            'updated' => 'Expense Updated Successfully',
            'deleted' => 'Expense Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense?',
            'selected_delete_message' => 'Are you sure you want to delete selected expense?',
            'details' => 'Expense Details',
            'expense_category' => 'Expense Category',
            'date' => 'Date',
            'amount' => 'Amount',
            'bill' => 'Expense Bill',
            'user' => 'User',
            'created_by_user' => 'User',
            'notes' => 'Notes',
        ],
        'staff_member' => [
            'add' => 'Add New Staff Member',
            'edit' => 'Edit Staff Member',
            'created' => 'Staff Member Created Successfully',
            'updated' => 'Staff Member Updated Successfully',
            'deleted' => 'Staff Member Deleted Successfully',
            'staff_member_details' => 'Staff Member Details',
            'staff_member' => 'Staff Member',
            'delete_message' => 'Are you sure you want to delete this staff member?',
            'selected_delete_message' => 'Are you sure you want to delete selected staff member?',
            'import_staff_members' => 'Import Staff Members',
        ],
        'product' => [
            'add' => 'Add New Product',
            'edit' => 'Edit Product',
            'created' => 'Product Created Successfully',
            'updated' => 'Product Updated Successfully',
            'deleted' => 'Product Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this product?',
            'selected_delete_message' => 'Are you sure you want to delete selected product?',
            'details' => 'Product Details',
            'name' => 'Name',
            'product_type' => 'Product Type',
            'price' => 'Price',
            'logo' => 'Logo',
            'tax_rate' => 'Tax Rate',
            'tax_label' => 'Tax Label',
        ],
        'form' => [
            'add' => 'Add New Form',
            'edit' => 'Edit Form',
            'created' => 'Form Created Successfully',
            'updated' => 'Form Updated Successfully',
            'deleted' => 'Form Deleted Successfully',
            'form_details' => 'Form Details',
            'delete_message' => 'Are you sure you want to delete this form?',
            'selected_delete_message' => 'Are you sure you want to delete selected form?',
            'form' => 'Form',
            'name' => 'Name',
            'status' => 'Status',
            'form_fields' => 'Form Fields',
            'add_form_field' => 'Add Form Field',
            'field_name' => 'Field Name',
            'status_update' => 'Status Updated Successfully',
        ],
        'form_field_name' => [
            'add' => 'Add New Lead Table Field',
            'edit' => 'Edit Lead Table Field',
            'created' => 'Lead Table Field Created Successfully',
            'updated' => 'Lead Table Field Updated Successfully',
            'deleted' => 'Lead Table Field Deleted Successfully',
            'form_field_name_details' => 'Lead Table Field Details',
            'delete_message' => 'Are you sure you want to delete this Form Field Name?',
            'selected_delete_message' => 'Are you sure you want to delete selected Form Field Name?',
            'field_name' => 'Field Name',
            'similar_field_names' => 'Similar Field Names',
            'visible' => 'Visible',
            'add_field' => 'Add Field',
            'status_update' => 'Status Updated Successfully',
        ],
        'lead' => [
            'add' => 'Add New Lead',
            'edit' => 'Edit Lead',
            'created' => 'Lead Created Successfully',
            'updated' => 'Lead Updated Successfully',
            'deleted' => 'Lead Deleted Successfully',
            'lead_details' => 'Lead Details',
            'delete_message' => 'Are you sure you want to delete this lead?',
            'reference_number' => 'Reference Number',
            'campaign' => 'Campaign Name',
            'view_lead_details' => 'View Lead Details',
            'edit_lead' => 'Edit Lead',
            'go_resume_call' => 'Go & Resume Call',
            'delete_lead' => 'Delete Lead',
            'search_by' => 'Search By',
            'search_value' => 'Search Value',
            'actioner' => 'Actioner',

            'call_by' => 'Called By',
            'called_on' => 'Called On',
            'call_duration' => 'Call Duration',
            'lead_data' => 'Lead Data',

            'booking_time' => 'Booking Time',
            'added_by' => 'Added By',
            'added_on' => 'Added On',

            'lead_status' => 'Lead Status',
            'interested' => 'Interested',
            'not_interested' => 'Not Interested',
            'unreachable' => 'Unreachable',
            'lead_number' => 'Lead Number',
            'started' => 'Started',
            'not_started' => 'Not Started',
            'are_you_want_to_resume_this_lead' => 'Are you sure you want to resume this lead?',
            'are_you_want_go_to_next_lead' => 'Are you sure you want to go to next lead?',
            'are_you_want_go_to_previous_lead' => 'Are you sure you want to go to previous lead?',
            'are_you_want_go_to_save_exit' => 'Are you sure you want to go save and exit lead?',
            'email_timeline_message' => 'Email sent by {0} on {1}',
            'call_log_timeline_message' => 'A new call started by {0} on {1}',
            'notes_timeline_message' => 'A new notes added by {0} on {1}',

            'lead_history' => 'Lead History',
            'no_lead_exists' => 'No Lead Exists',
            'no_lead_exist_message' => 'No lead exists... Select any options from below',
            'skip_or_delete' => 'Skip Or Delete',
            'skip_delete_message' => 'You can skip or delete the current lead. Select below option...',
            'skip_and_delete' => 'Skip & Delete',
            'skip_delete_confirm_message' => 'Are you sure you want to delete this lead... this action cannot be undo.',
            'lead_skiped_successflly' => 'Lead skiped successfully',
            'skip_delete_success_message' => 'Lead skiped and deleted successfully',
            'come_back_confirm_message' => 'Are you sure you want to skip this lead...',
            'combe_back_later' => 'Come Back Later',
            'you_are_on_next_lead' => 'You are on next lead',
            'you_are_on_previous_lead' => 'You are on previous lead',
            'send_email' => 'Send Email',
        ],
        'lead_follow_up' => [
            'add' => 'Add New Follow Up',
            'edit' => 'Edit Follow Up',
            'created' => 'Follow Up Created Successfully',
            'updated' => 'Follow Up Updated Successfully',
            'deleted' => 'Follow Up Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this follow up?',
            'selected_delete_message' => 'Are you sure you want to delete selected follow up?',
            'follow_up' => 'Follow Up',
            'follow_up_by' => 'Follow Up By',
            'follow_up_time' => 'Follow Up Time',
            'start_follow_up' => 'Start Follow Up',
            'start_follow_up_message' => 'Are you sure you want to start this follow up lead...',
            'follow_up_timeline_message' => 'Follow up added by {0} for staff member {1} for {2}',
            'delete_follow_up' => 'Delete Follow Up',
            'delete_follow_up_message' => 'Are you sure you want to delete this follow up',
        ],
        'salesman_booking' => [
            'add' => 'Add New Salesman Booking',
            'edit' => 'Edit Salesman Booking',
            'created' => 'Salesman Booking Created Successfully',
            'updated' => 'Salesman Booking Updated Successfully',
            'deleted' => 'Salesman Booking Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this salesman booking?',
            'selected_delete_message' => 'Are you sure you want to delete selected salesman booking?',
            'salesman_booking' => 'Salesman Booking',
            'salesman_bookings_by' => 'Salesman Booking By',
            'salesman_bookings_time' => 'Salesman Booking Time',
            'salesman_bookings_timeline_message' => 'A booking added by {0} for salesman {1} for {2}',
            'delete_salesman_booking' => 'Delete Salesman Booking',
            'delete_salesman_booking_message' => 'Are you sure you want to delete this salesman booking',
            'you_are_not_last_actioner' => 'You created this booking but you are not last actioner of this lead...',
        ],
        'company' => [
            'add' => 'Add New Company',
            'edit' => 'Edit Company',
            'created' => 'Company Created Successfully',
            'updated' => 'Company Updated Successfully',
            'deleted' => 'Company Deleted Successfully',
            'currency_details' => 'Company Details',
            'delete_message' => 'Are you sure you want to delete this company?',
            'name' => 'Company Name',
            'short_name' => 'Company Short Name',
            'email' => 'Company Email',
            'phone' => 'Company Phone',
            'address' => 'Company Address',
            'currency' => 'Currency',
            'logo' => 'Company Logo',
            'left_sidebar_theme' => 'Left Sidebar Theme',
            'dark' => 'Dark',
            'light' => 'Light',
            'dark_logo' => 'Dark Logo',
            'light_logo' => 'Light Logo',
            'small_dark_logo' => 'Small Dark Logo',
            'small_light_logo' => 'Small Light Logo',
            'primary_color' => 'Primary Color',
            'default_timezone' => 'Default Timezone',
            'date_format' => 'Date Format',
            'time_format' => 'Time Format',
            'auto_detect_timezone' => 'Auto Detect Timezone',
            'app_debug' => 'App Debug',
            'login_image' => 'Login Image',
            'layout' => 'Layout',
            'rtl' => 'RTL',
            'ltr' => 'LTR',
            'shortcut_menu_Placement' => 'Add Menu Placement',
            'top_and_bottom' => 'Top & Bottom',
            'top_header' => 'Top Header',
            'bottom_corner' => 'Bottom Conrer',
            'shortcut_menu_setting' => 'Add Menu Settings',
            'menu_setting_updated' => 'Menu Setting Updated',
            'basic_details' => 'Basic Details',
            'details' => 'Details',
            'register_date' => 'Register Date',
            'total_users' => 'Total Users',
            'update_app_notification' => 'Update App Notitication',
            'language' => 'Language'
        ],
        'currency' => [
            'add' => 'Add New Currency',
            'edit' => 'Edit Currency',
            'created' => 'Currency Created Successfully',
            'updated' => 'Currency Updated Successfully',
            'deleted' => 'Currency Deleted Successfully',
            'currency_details' => 'Currency Details',
            'delete_message' => 'Are you sure you want to delete this currency?',
            'selected_delete_message' => 'Are you sure you want to delete selected currency?',
            'name' => 'Currency Name',
            'symbol' => 'Currency Symbol',
            'position' => 'Currency Position',
            'front' => 'Front',
            'front_position_example' => 'Example : $100',
            'behind' => 'Behind',
            'behind_position_example' => 'Example : 100$',
            'code' => 'Currency Code',
        ],
        'module' => [
            'name' => 'Module Name',
            'verified' => 'Verified',
            'verify_purchase_code' => 'Verify Purchase Code',
            'current_version' => 'Current Version',
            'latest_version' => 'Latest Version',
            'status' => 'Status',
            'installed_modules' => 'Installed Modules',
            'other_modules' => 'Other Modules',
            'module_status_updated' => 'Modules Status Updated',
            'downloading_completed' => 'Download Completed',
            'extract_zip_file' => 'Extract Zip File',
            'file_extracted' => 'Zip File Extracted',
        ],
        'langs' => [
            'add' => 'Add New Language',
            'edit' => 'Edit Language',
            'details' => 'Language Details',
            'created' => 'Language Created Successfully',
            'updated' => 'Language Updated Successfully',
            'deleted' => 'Language Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this language?',
            'view_all_langs' => 'View All Languages',
            'status_updated' => 'Langugage status updated',
            'name' => 'Name',
            'key' => 'Key',
            'flag' => 'Flag',
            'enabled' => 'Enabled',
        ],
        'translations' => [
            'fetch_new_translations' => 'Fetch New Translations',
            'reload_translations' => 'Reload Translations',
            'reload_successfully' => 'Translations Reload Successfully',
            'fetched_successfully' => 'Translations Fetch Successfully',
            'import_translations' => 'Import Translations',
        ],
        'storage_settings' => [
            'updated' => 'Storage Settings Updated',
            'storage' => 'Storage',
            'local' => 'Local',
            'aws' => 'AWS S3 Storage',
            'aws_key' => 'AWS Key',
            'aws_secret' => 'AWS Secret',
            'aws_region' => 'AWS Region',
            'aws_bucket' => 'AWS Bucket',
        ],
        'mail_settings' => [
            'updated' => 'Mail Settings Updated',
            'mail_driver' => 'Mail Driver',
            'none' => 'None',
            'mail' => 'Mail',
            'smtp' => 'SMTP',
            'from_name' => 'Mail From Name',
            'from_email' => 'Mail From Email',
            'host' => 'Host',
            'port' => 'Port',
            'encryption' => 'Encryption',
            'username' => 'Username',
            'password' => 'Password',
            'send_test_mail' => 'Send Test Mail',
            'send_mail_setting_saved' => 'Send mail setting saved',
            'enable_mail_queue' => 'Enable Mail Queue',
            'send_mail_for' => 'Send Mail For',
            'email' => 'Email address for which you want to send test mail',
            'test_mail_sent_successfully' => 'Test mail sent successfully',
            'notificaiton_will_be_sent_to_company' => 'Notification will be sent to company email',
        ],
        'database_backup' => [
            'file' => 'File',
            'file_size' => 'File Size',
            'generate_backup' => 'Generate Backup',
            'delete_backup' => 'Delete Backup',
            'backup_generated_successfully' => 'Backup Generated Successfully',
            'are_you_sure_generate_backup' => 'Are you sure you want to generate database backup?',
            'are_you_sure_delete_backup' => 'Are you sure you want to delete this database backup?',
            'backup_locaion_is' => 'All generated database file will be stored in storage/app/public/backup folder. ',
            'settings' => 'Command Settings',
            'backup_command_setting' => 'Backup Command Settings',
            'mysqldump_command_path' => 'mysqldump command path',
            'command_updated' => 'Command updated successfully',
            'window_command_path' => 'If you use XAMPP then it will be => C:\xampp\mysql\bin\mysqldump.exe',
            'laragon_command_path' => 'If you use Laragon then it will be => C:\laragon\bin\mysql\mysql-5.7.24-winx64\bin\mysqldump.exe',
            'linux_command_path' => 'If you are on ubuntu or mac then run following command and enter output here => which mysqldump',
            'put_dump_path_command_on_env_file' => 'Find your MySQL dump path from below and then add it to the DUMP_PATH inside .env file',
        ],
        'update_app' => [
            'app_details' => 'App Details',
            'name' => 'Name',
            'value' => 'Value',
            'php_version' => 'PHP Version',
            'app_version' => 'App Version',
            'laravel_version' => 'Laravel Version',
            'mysql_version' => 'MySQL Version',
            'vue_version' => 'Vue Version',
            'update_app' => 'Update App',
            'update_now' => 'Update Now',
            'update_available' => 'Update Available',
            'verify_again' => 'Verify Again',
            'verify_failed' => 'Verification Failed',
            'verify_failed_message' => 'Your application is not registerd with us. Please verify it',
            'verified_with_other_domain' => 'Your purchase code is registerd with other doamin. Please verfiy your purhcase code',
        ],
        'messages' => [
            'somehing_went_wrong' => 'Something went wrong. Please contact to administrator.',
            'verify_success' => 'Successfully verified. Redirect to app...',
            'login_success' => 'Successfully login. Redirect to app...',
            'login_success_dashboard' => 'Successfully logged into app.',
            'click_here_to_find_purchase_code' => 'Click here to find your purchase code',
            'verification_successfull' => 'Verification successfully',
            'other_domain_linked' => 'Other domain linked',
            'other_domain_linked_with_purchase_code' => 'Other domain is already linked with your purchase code. Please enter your purchase code for more details...',
            'first_verify_module_message' => 'To enable please \n verify this module',
            'are_you_sure_install_message' => 'Are you sure you want to install?',
            'downloading_started_message' => 'Downloading started. Please wait ...',
            'file_extracting_message' => 'File extracteding. Please wait ...',
            'installation_success' => 'Installation successfully. Click here to reload page...',
            'are_you_sure_update_message' => 'Are you sure you want to update? Please take backup before update.',
            'stmp_success_message' => 'Your SMTP settings are correct..',
            'stmp_error_message' => 'Your SMTP settings are incorrect. Please update it to send mails',
            'uploading_failed' => 'Uploading failed',
            'loading_app_message' => 'Please wait... we are preparing something amazing for you',
            'fetching_product_details' => 'We are fetching product details. Please wait...',
            'product_is_upto_date' => 'You are on the latest version of app.',
            'new_app_version_avaialbe' => 'New app version {0} is available. Please update to get latest version.',
            'not_able_to_edit_order' => 'Only order status editable, other fields can not be editable becuase this order linked to some payments. Delete those payment(s) and try again.',
            'click_here_to_download_sample_file' => 'Click here to download sample csv file',
            'imported_successfully' => 'Imported Successfully',
            'company_admin_password_message' => 'Admin will login using this password. (Leave blank to keep current password)',
            'email_setting_not_configured' => 'Email setting not configured',
            'please_configure_email_settings' => 'Please configure your email settings to send emails. Click Here to configure email settings.',
        ],
        'popover' => [
            'auto_detect_timezone' => 'Allow auto detect timezone from browser for currently logged in user.',
            'click_here_to_copy_credentials' => 'Click here to copy {0} credentials',
        ],
        'topbar_add_button' => [
            'add_staff_member' => 'Add Staff Member',
            'add_currency' => 'Add Currency',
            'add_language' => 'Add Language',
            'add_role' => 'Add Role',
        ],
        'setup_company' => [
            'setup_not_completed' => 'Setup Not Completed',
            'setup_not_completed_description' => 'Your company default settings not completed. Follow below setups to complete your company basic settings...',
            'currency' => 'Currency',
            'add_first_currency' => 'Add First Currency',
            'company_settings' => 'Company Settings',
            'set_company_basic_settings' => 'Setup Company Basic Settings',
            'previous_step' => 'Previous Step',
            'next_step' => 'Next Step',
            'basic_settings' => 'Basic Settings',
            'theme_settings' => 'Theme Settings',
            'logo_settings' => 'Logo Settings',
            'save_finish_setup' => 'Save & Finish Setup',
            'go_to_dashboard' => 'Go To Dashboard',
            'setup_running_message' => 'Please wait... we are setting up inital company settings.',
            'setup_complete_message' => 'Setup completed... Click on below link to view your app...',
        ]
    ];

    public static $eStoreTranslations = [];

    public static function getTranslationArray($moduleName)
    {
        if ($moduleName == 'Estore') {
            return self::$eStoreTranslations;
        } else if ($moduleName == 'Superadmin') {
            return \App\SuperAdmin\Classes\SuperAdminLangTrans::$mainTranslations;
        }

        return self::$mainTranslations;
    }

    public static function seedTranslations($moduleName = '')
    {
        $allLangs = Lang::all();

        $translations = self::getTranslationArray($moduleName);

        foreach ($translations as $group => $translation) {
            foreach ($translation as $transKey => $transValue) {

                foreach ($allLangs as $allLang) {
                    $translationCount = Translation::where('lang_id', $allLang->id)
                        ->where('group', $group)
                        ->where('key', $transKey)
                        ->count();

                    if ($translationCount == 0) {
                        $newTranslation = new Translation();
                        $newTranslation->lang_id = $allLang->id;
                        $newTranslation->group = $group;
                        $newTranslation->key = $transKey;
                        $newTranslation->value = $transValue;
                        $newTranslation->save();
                    }
                }
            }
        }
    }

    public static function seedMainTranslations()
    {
        // Main Module
        self::seedTranslations();

        // Seed Translation for SAAS Version
        if (app_type() == 'saas') {
            self::seedTranslations('Superadmin');
        }

        // Seeding modules
        self::seedAllModulesTranslations();
    }

    public static function seedAllModulesTranslations()
    {
        $allModules = Module::all();
        foreach ($allModules as $allModule) {
            self::seedTranslations($allModule);
        }
    }
}
